/*------------------------------------------------------------------------------*
 * File Name: ImpWizDataColumns.h												*
 * Creation: Jason 12/14/2003													*
 * Purpose: Origin C file containing Application Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	 Jason 12/18/03 v7.5781 MOVE_TO_ON_INIT_DATA_COLUMNS						*
 *	 Jason 12/18/03 v7.5781 MOVED_INITIAL_FUNCTION								*
 *	 Jason 12/18/03 v7.5781 NO_NEED_DIALOG_CALL									*
 *	 Jason 12/18/03 v7.5781 ADD_UTILITY_FUNCTION								*
 *   Danice 12/23/03 v7.5786 SAVE_CHANGE										*
 *   Danice 12/25/03 v7.5788 SAVE_BEFORE_CHANGE									*
 *   Jason 12/26/03 v7.5789 USE_M_EDITFIXEDWIDTHS								*
 *   Jason 12/26/03 v7.5789 USE_M_CMBDESIG										*
 *   Jason 12/26/03 v7.5789 USE_M_EBDELIMITER									*
 *   Jason 12/26/03 v7.5789 USE_M_CMBDELIMITER									*
 *   Danice 12/26/03 v7.5789 UPDATE_DIRECTLY									*
 *   Danice 12/26/03 v7.5789 PUT_FUNCTION_TO_SHEET								*
 *   Danice 12/29/03 v7.5790 ADD_BUSY_IN_SHEET									*
 *   Danice 1/9/04 V8.0797 USE_AS_DATA_MEMBER									*
 *   Danice 1/16/04 v8.0800 USE_ONLY_IN_DATA_COLUMNS							*
 *   Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER						*
 *   Danice 1/16/04 v8.0800 MOVE_UTILITY_TO_CPP_FILE							*
 *   Danice 1/16/04 v8.0800 FIT_FUNCTION_ARGUMENT								*
 *   Danice 2/12/04 v8.0819 CHANGE_GRID_TO_CLASS								*
 *   Danice 2/16/04 v8.0821 ADD_SOME_ACCESS_FUNCTION							*
 *   Danice 2/16/04 v8.0821 FUNCTION_IN_RESIZE_CONTROL							*
 *   Danice 2/20/04 v8.0822 INIT_GRID											*
 * EJP 02-26-2004 v7.5828 ONLY_CREATE_WKS_CTRL_ONCE								*
 *   Danice 3/1/04 v8.0828 PAGE_INIT_ONCE										*
 *   Danice 3/29/04 v8.0844b CHANGE_PARA_ORDER_ROW_COL							*
 *   SY 06-09-2004 v7.5886 QA70-5417.33 APPLY_CUSTOM_DATE_FORMAT				*
 * EJP 2005-03-04 v8.0200 QA70-7433 IMPORT_CSV_FILES							*
 * EJP 2005-06-23 v8.0256 QA70-5705 ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS			*
 * EJP 2005-09-23 v8.0309 QA70-7473 ASC_IMP_MULT_DELIM							*
 * Hong 01/17/07 ADD_SPARKLINE_TO_IMPORT_WIZARD									*
 * Hong 03/26/07 v8.0589b ADD_FORCE_ROW_SAME_SIZE								*
 *	Hong 04/11/07 v8.0598 MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT				*
 *	Sim 06-05-2007 LOAD_FILTER_DESIGN_TO_DLG									*
 *	Sim 08-06-2007 SUPPORT_SMART_SPARKLINE										*
 *	Hong 03/27/09 QA80-13360 ADD_HINT_ITEM_FOR_DATA_FMT_COMBO					*
 *	Hong 10/10/09 QA80-14079-P2 COL_DESIG_SETTING_LOST_UNFRIENDLY_AFTER_FORWARD_BACK
 *	Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
 *------------------------------------------------------------------------------*/


#define ON_PAGE_CHECK_ASC_COLUMNS			if(!IS_SHOW_ASC_COLUMNS_PAGE) return FALSE;

class ASCColumnsPreviewList : public GridListControl
{
public:
	ASCColumnsPreviewList();
	///Danice 2/16/04 v8.0821 ADD_SOME_ACCESS_FUNCTION
	void Init(int nID, int iRenameCols, WndContainer& dlg);
	///END ADD_SOME_ACCESS_FUNCTION
	
	///Danice ADD_SOME_ACCESS_FUNCTION
	void ReadFileIntoFixedWidthGrid(string strFileName, int iTotalHeaderLines, int iRenameCols);
	void SetGridColWidthInChars(int nCol, int nChars, int FixedWidthGridFont);
	///END ADD_SOME_ACCESS_FUNCTION
};

// Derived WizPage class for WizPage1
class ImpWizDataColumnsPage : public ImpWizardPage
{
	// Constructor for ImpWizDataColumnsPage class, use parent constructor
	//ImpWizDataColumnsPage(int nID) : ImpWizardPage(nID) {}
	
public:
	// TD 1-14-03
	ImpWizDataColumnsPage();
	// end 1-14-03
	
	EVENTS_BEGIN
		//PAGE_ON_IS_SHOW(OnIsShowASCII)	///Danice 12/25/03 v7.5788 NOTUSE_SHOW
		PAGE_ON_INIT(OnInit_AscColumns)
		PAGE_ON_ACTIVE(OnActive_AscColumns)
		PAGE_ON_KILLACTIVE(OnKillActive_AscColumns)
	
		ON_BN_CLICKED(IDC_COLS_DELIMITED, OnClickDelimited_AscColumns)
		ON_CBN_SELCHANGE(IDC_COLS_DELIMITER, OnSelChangeDelimiter_AscColumns)
		ON_EN_CHANGE(IDC_COLS_CHAR, OnEditChangeCharacter_AscColumns)
		ON_EN_CHANGE(IDC_COLS_WIDTHS, OnEditChangeColumnWidths_AscColumns)
	
		/// EJP 07-21-2003 v7.0630 QA70-4073 ADD_APPLY_BUTTON_TO_UPDATE_PREVIEW
		///ON_EN_CHANGE(IDC_NUMBER_OF_COLS, AscCols_OnChangeNumCols)
		ON_BN_CLICKED(IDC_APPLY_NUM_COLS, OnClickApplyNumCols_AscCols)
		/// end ADD_APPLY_BUTTON_TO_UPDATE_PREVIEW
	
		ON_BN_CLICKED(IDC_COLS_REFRESH, OnClickRefresh_AscColumns)
		ON_BN_CLICKED(IDC_IW_COL_SET_PLOT_DESIG, OnClickSetDesignations_AscColumns)
	///	ON_ORIGIN_CHANGE(SN_COL_CHANGE_PLOT_DESIGNATION, AscColumns_OnOriginChangeWks)
	///	ON_ORIGIN_CHANGE(SN_COL_CHANGE_FORMAT, AscColumns_OnOriginChangeWks)
	///	ON_WKSCTRL_EVENT(WKSCTRL_EVENT_TYPE_CHANGE, AscColumns_OnChangeColTypeOrDesignation)
		ON_BN_CLICKED(IDC_COL_PREV_SWITCH, OnClickFixedWidthPreview_AscColumns)
		ON_GRID_AFTER_USER_RESIZE(IDC_COL_WIDTH_PREVIEW_GRID, OnAfterResizeGridCol_AscColumns)
		ON_GRID_DRAW_CELL(IDC_COL_WIDTH_PREVIEW_GRID, OnDrawCell_AscColumns)
		ON_BN_CLICKED(IDC_ADD_COL, OnClickAddCol_AscColumns)
		ON_BN_CLICKED(IDC_DEL_COL, OnClickDelCol_AscColumns)
		ON_BN_CLICKED(IDC_IW_LEADING_ZERO, OnClickLeadingZeroes_AscColumns)
	
		ON_BN_CLICKED(IDC_APPLY_DATE_FORMAT, AscCols_ApplyDateFormat) /// EJP 10-13-2003 v7.5717 QA70-5318 CUSTOM_DATE_FORMAT
		ON_BN_CLICKED(IDC_REMOVE_QUOTES, OnClickRemoveQuotes) /// EJP 2005-03-04 v8.0200 QA70-7433 IMPORT_CSV_FILES
		ON_CBN_SELCHANGE(IDC_NUM_SEPARATOR, OnSelChangeNumSep) /// EJP 2005-06-23 v8.0256 QA70-5705 ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS
		
		/// EJP 2005-09-23 v8.0309 QA70-7473 ASC_IMP_MULT_DELIM
		ON_BN_CLICKED(IDC_COL_DELIM_TAB, OnClickDelimiter)
		ON_BN_CLICKED(IDC_COL_DELIM_COMMA, OnClickDelimiter)
		ON_BN_CLICKED(IDC_COL_DELIM_SPACE, OnClickDelimiter)
		ON_BN_CLICKED(IDC_COL_DELIM_SEMICOLON, OnClickDelimiter)
		ON_BN_CLICKED(IDC_COL_DELIM_OTHER, OnClickDelimiter)
		ON_BN_CLICKED(IDC_DELIM_COMBINE_CONSEC, OnClickCombineConsecDelim)
		ON_CBN_SELCHANGE(IDC_TEXT_QUALIFIER, OnSelChangeTextQualifier)
		ON_CBN_EDITCHANGE(IDC_TEXT_QUALIFIER, OnEditChangeTextQualifier)
		/// end ASC_IMP_MULT_DELIM
		///---Sim 08-06-2007 SUPPORT_SMART_SPARKLINE
		//ON_BN_CLICKED(IDC_IW_ADD_SPARKLINES, OnClickAddSparklines) // Hong 01/17/07 ADD_SPARKLINE_TO_IMPORT_WIZARD
		ON_CBN_SELCHANGE(IDC_IW_ADD_SPARKLINES, OnSelChangeSparklines)
		///---END SUPPORT_SMART_SPARKLINE
		
		ON_BN_CLICKED(IDC_IW_FILL_NANUM_FORCE_SAME_SIZE, OnClickForceSameSize) // Hong 03/26/07 v8.0589b ADD_FORCE_ROW_SAME_SIZE
		
		ON_BN_CLICKED(IDC_IW_KEEP_COL_FORMAT, OnClickKeepColFormat) // Hong 04/11/07 v8.0598 MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT
		
		/// Hong 03/27/09 QA80-13360 ADD_HINT_ITEM_FOR_DATA_FMT_COMBO
		ON_CBN_SELCHANGE(IDC_CUSTOM_DATE_FORMAT, OnSelChangeDataFormat)
		/// end ADD_HINT_ITEM_FOR_DATA_FMT_COMBO

		/// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
		ON_EN_CHANGE(IDC_NUMBER_OF_COLS, OnChangeNumCols)
		ON_CBN_EDITCHANGE(IDC_CUSTOM_DATE_FORMAT, OnChangeDateFormat)
		ON_CBN_EDITCHANGE(IDC_IW_COL_PLOT_DESIG, OnChangePlotDisg)
		ON_CBN_SELCHANGE(IDC_IW_COL_PLOT_DESIG, OnSelChangePlotDisg)
		/// end IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
		
	EVENTS_END

	///Danice 12/25/03 v7.5788 NOTUSE_SHOW
	DWORD    OnShowStatus(DWORD InternalStatus);
	///END NOTUSE_SHOW
	
	BOOL OnInit_AscColumns();	//Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
	
	BOOL OnActive_AscColumns();	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
	
	bool OnKillActive_AscColumns();
	
	BOOL OnClickLeadingZeroes_AscColumns(Control ctrl);	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
	
	BOOL OnClickDelimited_AscColumns(Control ctrl);	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
	
	BOOL	OnSelChangeDelimiter_AscColumns(Control ctrl);	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
	
	BOOL	OnEditChangeCharacter_AscColumns(Control ctrl);	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
	
	BOOL	OnEditChangeColumnWidths_AscColumns(Control ctrl);	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
	
	/// EJP 07-21-2003 v7.0630 QA70-4073 ADD_APPLY_BUTTON_TO_UPDATE_PREVIEW
	///static BOOL AscCols_OnChangeNumCols(Control ctrl)
	BOOL OnClickApplyNumCols_AscCols(Control ctrl);	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
	/// end ADD_APPLY_BUTTON_TO_UPDATE_PREVIEW
	
	/// EJP 10-13-2003 v7.5717 QA70-5318 CUSTOM_DATE_FORMAT
	BOOL AscCols_ApplyDateFormat(Control ctrl);
	/// end CUSTOM_DATE_FORMAT
	BOOL OnSelChangeNumSep(Control ctrl); /// EJP 2005-06-23 v8.0256 QA70-5705 ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS
	
	void AscColumns_UpdateFixedWidthColStr();
	
	BOOL	OnClickRefresh_AscColumns(Control ctrl);	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
	
	BOOL	OnClickSetDesignations_AscColumns(Control ctrl);	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
	
	void AscColumns_EnableDelimiterCtrls();
	
	bool AscColumns_SetColumnDesignations(LPCSTR lpcszDesignations);
	
	BOOL OnClickFixedWidthPreview_AscColumns(Control ctrl);	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
	
	BOOL OnClickAddCol_AscColumns(Control ctrl);	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
	
	BOOL OnClickDelCol_AscColumns(Control ctrl);	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
	
	BOOL OnAfterResizeGridCol_AscColumns(Control ctrl, int nRow, int nCol);	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
	
	void OnDrawCell_AscColumns(Control ctrl, UINT dwDC, int nRow, int nCol, int nLeft, int nTop, int nRight, int nBottom, BOOL* pDone);	///Jason 12/14/03 v7.5781 CHANGE_SOME_FUNCTION_NAME
	
	int AscColumns_GetGridColWidthInChars(int nCol);
	
	void AscColumns_UpdateGridColTitle(int nCol);
	
	void AscColumns_SetGridColWidthInChars(int nCol, int nChars);
	
	void AscColumns_SetGridColWidthInChars(vector<short> vColWidths);
	
	void AscColumns_ReadFileIntoFixedWidthGrid();
	
	void AscColumns_AddColToFixedWidthGrid();
	
	void AscColumns_DeleteColFromFixedWidthGrid();
	
	void AscColumns_UpdateData(BOOL bFromDialogToASCIMP=TRUE);

	void UpdatePreview(int iWizPageID);
	
	/// EJP 07-14-2003 v7.0624 SCAN_FOR_NUM_COLS_ON_CHANGE_HEADER_LINES
	int iwScanForNumColumns(LPCSTR lpcszFile, ASCIMP& ascimp);
	/// end SCAN_FOR_NUM_COLS_ON_CHANGE_HEADER_LINES
	BOOL OnClickRemoveQuotes(Control ctrl); /// EJP 2005-03-04 v8.0200 QA70-7433 IMPORT_CSV_FILES

	void UpdateWksCtrl(int iWizPageID);

	/// EJP 2005-09-23 v8.0309 QA70-7473 ASC_IMP_MULT_DELIM
	BOOL OnClickDelimiter(Control ctrl);
	BOOL OnClickCombineConsecDelim(Control ctrl);
	BOOL OnSelChangeTextQualifier(Control ctrl);
	BOOL OnEditChangeTextQualifier(Control ctrl);
	int UpdateASCIMPDelimitersFromDialog();
	int UpdateDialogFromASCIMPDelimiters();
	void UpdateTextQualifier(BOOL bFromDialogToASCIMP);
	/// end ASC_IMP_MULT_DELIM
	///---Sim 08-06-2007 SUPPORT_SMART_SPARKLINE
	//BOOL OnClickAddSparklines(Control ctrl);// Hong 01/17/07 ADD_SPARKLINE_TO_IMPORT_WIZARD
	BOOL OnSelChangeSparklines(Control ctrl);
	///---END SUPPORT_SMART_SPARKLINE
	
	BOOL OnClickForceSameSize(Control ctrl); // Hong 03/26/07 v8.0589b ADD_FORCE_ROW_SAME_SIZE
	
	BOOL OnClickKeepColFormat(Control ctrl); // Hong 04/11/07 v8.0598 MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT

	void CheckDelimiter(char c);
	
	/// Hong 03/27/09 QA80-13360 ADD_HINT_ITEM_FOR_DATA_FMT_COMBO
	BOOL OnSelChangeDataFormat(Control ctrl);
	/// end ADD_HINT_ITEM_FOR_DATA_FMT_COMBO

	/// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	BOOL OnChangeNumCols(Control ctrl);
	BOOL OnChangeDateFormat(Control ctrl);
	BOOL OnChangePlotDisg(Control ctrl);
	BOOL OnSelChangePlotDisg(Control ctrl);
	/// end IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT

	///---Sim 06-05-2007 LOAD_FILTER_DESIGN_TO_DLG
protected:
	void LoadDesignation(const TreeNode& trFilter);
	///---END LOAD_FILTER_DESIGN_TO_DLG
	
	/// Hong 10/10/09 QA80-14079-P2 COL_DESIG_SETTING_LOST_UNFRIENDLY_AFTER_FORWARD_BACK
	bool GetGUIColDesig(const TreeNode& trFilter, string& strDesignations);
	/// end COL_DESIG_SETTING_LOST_UNFRIENDLY_AFTER_FORWARD_BACK
	
private:
	WorksheetControl m_wc;
	
	//Control m_ctrlGrid;	///Danicee CHANGE_GRID_TO_CLASS
	
	Button m_rbDelimited;		///Danice 1/9/04 V8.0797 USE_AS_DATA_MEMBER
	Button m_btnLeadingZeroes;
	Button m_btnRefresh;
	Button m_chkFixedWidthGrid;
	Button m_btnAddCol;
	Button m_btnDelCol;

	Button m_btnRemoveQuotes; /// EJP 2005-03-04 v8.0200 QA70-7433 IMPORT_CSV_FILES

	Edit m_ebNumCols;
	Edit m_editFixedWidths;
	Edit m_ebDelimiter;
	
	ComboBox m_cbDateFormat;
	
	/// EJP 2005-09-23 v8.0309 QA70-7473 ASC_IMP_MULT_DELIM
	///ComboBox m_cmbDelimiter;
	Button m_chkColDelimTab;
	Button m_chkColDelimComma;
	Button m_chkColDelimSpace;
	Button m_chkColDelimSemiColon;
	Button m_chkColDelimOther;
	Button m_chkCombineConsecDelim;
	ComboBox m_cbTextQualifier;
	/// end ASC_IMP_MULT_DELIM
	///---Sim 08-06-2007 SUPPORT_SMART_SPARKLINE
	//Button m_chkAddSparklines;	// Hong 01/17/07 ADD_SPARKLINE_TO_IMPORT_WIZARD
	ComboBox m_cbSparklines;
	///---END SUPPORT_SMART_SPARKLINE
	ComboBox m_cmbDesig;
	ComboBox m_cbNumSeparator; /// EJP 2005-06-23 v8.0256 QA70-5705 ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS
	
	Button m_chkForceSameSize; // Hong 03/26/07 v8.0589b ADD_FORCE_ROW_SAME_SIZE
	
	Button m_chkKeepColFormat; // Hong 04/11/07 v8.0598 MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT
	
	//ASCIMP 		m_pAscimp;			///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	ASCIMP* 		m_pAscimp;
	vector<short> m_vColWidths;
	
	BOOL		m_bInit; //TD 1-14-04

	ASCColumnsPreviewList	m_ctrlPreviewList ;
	/// Hong 08/05/10 ORG-721 IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
	BOOL		m_bDisableUpdatePreview;
	/// end IMPWIZ_SETTING_WITH_APPLY_BTN_SHOULD_AUTO_APPLY_WHEN_NEXT
};
